#include "VOS_API/DX_VOS_ThreadStorage.h"
#include "VOS_API/DX_VOS_Mem.h"
#include "VOS_API/DX_VOS_Thread.h"

#define DX_VOS_THREAD_MASK (DX_VOS_THREAD_RESOLUTION - 1)
void DX_VOS_ThreadStorageInit(DxVosThreadStorage threadStorage)
{
    DX_VOS_MemSetZero(threadStorage, sizeof(DxVosThreadStorage));
}

void DX_VOS_ThreadStoragePut(DxVosThreadStorage threadStorage, void* data)
{
    DxUint32 threadId = DX_VOS_GetCurrThreadId() & DX_VOS_THREAD_MASK;
    threadStorage[threadId] = data;
}

void* DX_VOS_ThreadStorageGet(DxVosThreadStorage threadStorage)
{
    DxUint32 threadId = DX_VOS_GetCurrThreadId() & DX_VOS_THREAD_MASK;
    return threadStorage[threadId];

}

